﻿using Moq;
using Ninject;
using Ninject.Web.Common;
using NVCC.Models;
using NVCC.Repos.AodRepository;
using NVCC.Repos.MdwsRepository;
using NVCC.Repos.PatientRepository;
using NVCC.Repos.UserRepository;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Web.Mvc;

namespace NVCC.WebUI.Infrastructure
{
    public class NinjectDependencyResolver : IDependencyResolver
    {
        private IKernel kernel;

        public NinjectDependencyResolver(IKernel kernelParam)
        {
            kernel = kernelParam;
            AddBindings();
        }

        public object GetService(Type serviceType)
        {
            return kernel.TryGet(serviceType);
        }

        public IEnumerable<object> GetServices(Type serviceType)
        {
            return kernel.GetAll(serviceType);
        }

        private void AddBindings()
        {
            //// BINDINGS FOR FAKE DATA
            //Mock<IUserRepository> userMock = new Mock<IUserRepository>();

            //Mock<IPatientProfileService> patientProfileServiceMock = new Mock<IPatientProfileService>();
            //patientProfileServiceMock.Setup(m => m.GetPatient(It.IsAny<string>(), It.IsAny<short>()))
            //  .Returns(FakeDataManager.GetPatient());
            //patientProfileServiceMock.Setup(m => m.GetPatientProfile(It.IsAny<Patient>(), It.IsAny<ViaUser>()))
            //   .Returns(FakeDataManager.GetPatientProfile());
            //patientProfileServiceMock.Setup(
            //    m => m.LogItem(It.IsAny<Stopwatch>(), It.IsAny<Patient>(), It.IsAny<string>(), It.IsAny<string>())).Verifiable();

            //Mock<IPatientRepository> patientRepoMock = new Mock<IPatientRepository>();
            //patientRepoMock.Setup(m => m.WriteAnnouncement(It.IsAny<AnnouncementItem>()))
            //    .Callback((AnnouncementItem ai) => FakeDataManager.AddAnnouncement(new UspAnnouncement() { AnnouncementID = ai.AnnouncementID, AnnouncementType = "Alert", CreationDT = ai.CreationDT, Creator = ai.Creator, ExpirationDT = ai.ExpirationDT, Text = ai.Text }));
            //patientRepoMock.Setup(m => m.GetAnnouncements(It.IsAny<int>()))
            //    .Returns((int i) => FakeDataManager.GetAnnouncements(i));

            //kernel.Bind<IPatientRepository>().ToConstant(patientRepoMock.Object).InRequestScope();
            //kernel.Bind<IUserRepository>().ToConstant(userMock.Object).InRequestScope();
            //kernel.Bind<IPatientProfileService>().ToConstant(patientProfileServiceMock.Object).InRequestScope();
            //kernel.Bind<IUserSessionManager>().To<UserSessionManager>().InRequestScope();
            //kernel.Bind<IUserService>().To<FakeUserService>().InRequestScope();
            //kernel.Bind<ICurrentUser>().To<FakeCurrentUser>().InRequestScope();

            // BINDINGS FOR REAL DATA
            kernel.Bind<IPatientRepository>().To<PatientRepository>().InRequestScope();
            kernel.Bind<IViaRepository>().To<ViaRepository>().InRequestScope();
            kernel.Bind<IUserRepository>().To<UserRepository>().InRequestScope();
            kernel.Bind<IPatientProfileService>().To<PatientProfileService>().InRequestScope();
            kernel.Bind<IUserSessionManager>().To<UserSessionManager>().InRequestScope();
            kernel.Bind<IUserService>().To<UserService>().InRequestScope();
            kernel.Bind<ICurrentUser>().To<CurrentUser>().InRequestScope();
            kernel.Bind<ICombinePdfService>().To<CombinePdfService>().InRequestScope();
            kernel.Bind<IAodRepository>().To<AodRepository>().InRequestScope();
            kernel.Bind<IAodService>().To<AodService>().InRequestScope();
            kernel.Bind<IRoiService>().To<RoiService>().InRequestScope();
            kernel.Bind<IAccessiblePdfService>().To<AccessiblePdfService>().InRequestScope();
            kernel.Bind<IImageService>().To<ImageService>().InRequestScope();
        }
    }
}